/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.settings.snmp.SnmpConstants;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SnmpEventBean
extends PanelBean
implements SnmpConstants,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPEBT";
    private static final String TRACE_MASKF = "XSNMPEBF";
    private static final String TRACE_MASKD = "XSNMPEBD";
    private String m_sTcpipAddressEdit = "";
    private ItemDescriptor[][] m_idEventsTable = new ItemDescriptor[0][0];
    private ColumnDescriptor[] m_cdEventsTableStructure = new ColumnDescriptor[0];
    private int[] m_iEventsTableSelection = new int[0];
    private ArrayList trapEventList = new ArrayList();
    private HashMap trapMap = new HashMap();
    private ArrayList selectedEventList = null;
    private static final String SNMP_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String SNMP_MESSAGE_BOX_TITLE_KEY = "SNMP.TITLE";
    private static final String SNMP_ADDRESS_MISSING_TEXT_KEY = "SNMP005.TEXT";
    private static final String SNMP_ADDRESS_INVALID_TEXT_KEY = "SNMP006.TEXT";

    public void setTcpipAddressEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.setTcpipAddressEdit(" + s + ")");
        this.m_sTcpipAddressEdit = s;
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.setTcpipAddressEdit()");
    }

    public String getTcpipAddressEdit() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.getTcpipAddressEdit()");
        return this.m_sTcpipAddressEdit;
    }

    public void setEventsTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.setEventsTableSelection(" + selected + ")");
        this.m_iEventsTableSelection = selected;
        Trace.trace(TRACE_MASKT, "<- SnmpEventsBean.setEventsTableSelection()");
    }

    public int[] getEventsTableSelection() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.getEventsTableSelection()");
        return this.m_iEventsTableSelection;
    }

    public void setEventsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.setEventsTableRowAt(" + index + ", " + items + ")");
        this.m_idEventsTable[index] = items;
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.setEventsTableRowAt()");
    }

    public ItemDescriptor[] getEventsTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.getEventsTableRowAt(" + index + ")");
        return this.m_idEventsTable[index];
    }

    public int getEventsTableRowCount() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.getEventsTableRowCount()");
        return this.m_idEventsTable.length;
    }

    public int getEventsTableRowStatus() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.getEventsTableRowStatus()");
        return 3;
    }

    public ColumnDescriptor[] getEventsTableRowStructure() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.getEventsTableRowStructure()");
        return this.m_cdEventsTableStructure;
    }

    public void setSelectedEvents(ArrayList eventList) {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.setSelectedEvents(" + eventList + ")");
        this.selectedEventList = eventList;
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.setSelectedEvents()");
    }

    public void initializeEventsTableData(HashMap tableData) {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.initializeEventsTableData(" + tableData + ")");
        this.trapMap = tableData;
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.initializeEventsTableData()");
    }

    private void populateEventsTable() {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.populateEventsTable()");
        this.m_idEventsTable = new ItemDescriptor[this.trapEventList.size()][1];
        for (int i = 0; i < this.trapEventList.size(); ++i) {
            ItemDescriptor[] row = new ItemDescriptor[1];
            Map.Entry mapEntry = (Map.Entry)this.trapEventList.get(i);
            String key = (String)mapEntry.getKey();
            String event = ((LocalizableText)mapEntry.getValue()).toString();
            row[0] = new ItemDescriptor(key, event);
            this.setEventsTableRowAt(i, row);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.populateEventsTable()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.load()");
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.load()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.prepare()");
        Set entrySet = this.trapMap.entrySet();
        this.trapEventList = new ArrayList(entrySet);
        Collections.sort(this.trapEventList, new SortByValue());
        this.populateEventsTable();
        if (this.selectedEventList != null) {
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            block0: for (int i = 0; i < this.selectedEventList.size(); ++i) {
                String eventKey = (String)this.selectedEventList.get(i);
                for (int j = 0; j < this.trapEventList.size(); ++j) {
                    Map.Entry mapEntry = (Map.Entry)this.trapEventList.get(j);
                    String key = (String)mapEntry.getKey();
                    if (!key.equals(eventKey)) continue;
                    selectedIndices.add(new Integer(j));
                    continue block0;
                }
            }
            int[] selectedEvents = new int[selectedIndices.size()];
            for (int k = 0; k < selectedIndices.size(); ++k) {
                selectedEvents[k] = (Integer)selectedIndices.get(k);
            }
            this.m_iEventsTableSelection = selectedEvents;
        } else {
            int[] selectedEvents = new int[this.trapEventList.size()];
            for (int k = 0; k < this.trapEventList.size(); ++k) {
                selectedEvents[k] = k;
            }
            this.m_iEventsTableSelection = selectedEvents;
        }
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.prepare()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> SnmpEventBean.save()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> SnmpEventBean.panelAction(" + event + ")");
        this.userTaskManager.storeAllElements();
        String elementName = event.getElementName();
        if (elementName.endsWith("OKButton")) {
            if (this.isInputGood()) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("PANEL", "SnmpEventPanel");
                request.setData("EVENT", "OK");
                ArrayList<String> trapKeyList = new ArrayList<String>();
                int[] selectedRows = this.getEventsTableSelection();
                for (int i = 0; i < selectedRows.length; ++i) {
                    int selectedRow = selectedRows[i];
                    Map.Entry mapEntry = (Map.Entry)this.trapEventList.get(selectedRow);
                    String trapKey = (String)mapEntry.getKey();
                    trapKeyList.add(trapKey);
                }
                request.setData("IP_ADDRESS", this.m_sTcpipAddressEdit);
                request.setData("TRAP_LIST", trapKeyList);
                this.postTaskletRequest(request);
            }
        } else if (elementName.endsWith("CancelButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "SnmpEventPanel");
            request.setData("EVENT", "CANCEL");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpEventBean.panelAction()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInputGood() {
        if (this.getTcpipAddressEdit().length() > 0) {
            try {
                InetAddress.getByName(this.getTcpipAddressEdit());
                return true;
            }
            catch (UnknownHostException exc) {
                try {
                    CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_ADDRESS_INVALID_TEXT_KEY));
                    return false;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, e);
                }
                return false;
            }
        }
        try {
            CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_ADDRESS_MISSING_TEXT_KEY));
            return false;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return false;
    }

    private static class SortByValue
    implements Comparator,
    Serializable {
        private SortByValue() {
        }

        public int compare(Object o1, Object o2) {
            Map.Entry e1 = (Map.Entry)o1;
            Map.Entry e2 = (Map.Entry)o2;
            String s1 = ((LocalizableText)e1.getValue()).toString();
            String s2 = ((LocalizableText)e2.getValue()).toString();
            return s1.compareTo(s2);
        }
    }
}

